<?php
require_once("../includes/db_connect.php");
session_start();

// Pastikan pasien sudah login
if (!isset($_SESSION['id_pasien'])) {
    echo "<script>alert('Silakan login terlebih dahulu!'); window.location.href='../login.php';</script>";
    exit();
}

$id_pasien = $_SESSION['id_pasien'];
$success_msg = "";
$error_msg = "";

// Ambil data pasien saat ini
$qPasien = $conn->prepare("
    SELECT * FROM data_diri_pasien 
    WHERE id_pasien = ?
");
$qPasien->bind_param("i", $id_pasien);
$qPasien->execute();
$pasien = $qPasien->get_result()->fetch_assoc();
$qPasien->close();

// Proses update data
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update'])) {
    $nama_pasien = $conn->real_escape_string($_POST['nama_pasien']);
    $email = $conn->real_escape_string($_POST['email']);
    $no_telepon = $conn->real_escape_string($_POST['no_telepon']);
    $alamat = $conn->real_escape_string($_POST['alamat']);
    
    // Proses upload foto jika ada
    $foto_profil = $pasien['foto_profil']; // default ke foto lama
    
    if (isset($_FILES['foto_profil']) && $_FILES['foto_profil']['error'] == 0) {
        $allowed_types = ['image/jpeg', 'image/png', 'image/jpg'];
        $file_type = $_FILES['foto_profil']['type'];
        
        if (in_array($file_type, $allowed_types)) {
            $upload_dir = "../uploads/pasien/";
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            
            $file_extension = pathinfo($_FILES['foto_profil']['name'], PATHINFO_EXTENSION);
            $new_filename = "pasien_" . $id_pasien . "_" . time() . "." . $file_extension;
            $upload_path = $upload_dir . $new_filename;
            
            if (move_uploaded_file($_FILES['foto_profil']['tmp_name'], $upload_path)) {
                // Hapus foto lama jika bukan default
                if ($foto_profil && $foto_profil != 'default.png' && file_exists($upload_dir . $foto_profil)) {
                    unlink($upload_dir . $foto_profil);
                }
                $foto_profil = $new_filename;
            }
        }
    }
    
    // Update password jika diisi
    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $conn->prepare("
            UPDATE data_diri_pasien 
            SET nama_pasien = ?, email = ?, no_telepon = ?, alamat = ?, foto_profil = ?, password = ?
            WHERE id_pasien = ?
        ");
        $stmt->bind_param("ssssssi", $nama_pasien, $email, $no_telepon, $alamat, $foto_profil, $password, $id_pasien);
    } else {
        $stmt = $conn->prepare("
            UPDATE data_diri_pasien 
            SET nama_pasien = ?, email = ?, no_telepon = ?, alamat = ?, foto_profil = ?
            WHERE id_pasien = ?
        ");
        $stmt->bind_param("sssssi", $nama_pasien, $email, $no_telepon, $alamat, $foto_profil, $id_pasien);
    }
    
    if ($stmt->execute()) {
        $success_msg = "Profil berhasil diperbarui!";
        // Refresh data pasien
        $qPasien = $conn->prepare("SELECT * FROM data_diri_pasien WHERE id_pasien = ?");
        $qPasien->bind_param("i", $id_pasien);
        $qPasien->execute();
        $pasien = $qPasien->get_result()->fetch_assoc();
        $qPasien->close();
    } else {
        $error_msg = "Gagal memperbarui profil: " . $conn->error;
    }
    $stmt->close();
}
?>

<div class="page-setting">
    <h2>⚙️ Pengaturan Profil</h2>
    <p>Kelola informasi profil dan akun kamu di sini ya! 🦷</p>

    <?php if ($success_msg): ?>
    <div class="alert alert-success">
        <?= $success_msg ?>
    </div>
    <?php endif; ?>

    <?php if ($error_msg): ?>
    <div class="alert alert-error">
        <?= $error_msg ?>
    </div>
    <?php endif; ?>

    <div class="setting-container">
        <div class="form-section">
            <h3>Edit Profil</h3>
            <form action="" method="POST" enctype="multipart/form-data">
                <div class="foto-profil">
                    <img src="../uploads/pasien/<?= $pasien['foto_profil'] ?? 'default.png' ?>" 
                         alt="Foto Profil" 
                         style="width: 100px; height: 100px; border-radius: 50%; object-fit: cover; margin-bottom: 10px;">
                    <br>
                    <label for="foto_profil">Ubah Foto Profil</label>
                    <input type="file" id="foto_profil" name="foto_profil" accept="image/*">
                </div>

                <label for="nama_pasien">Nama Lengkap</label>
                <input type="text" id="nama_pasien" name="nama_pasien" 
                       value="<?= htmlspecialchars($pasien['nama_pasien'] ?? '') ?>" required>

                <label for="email">Email</label>
                <input type="email" id="email" name="email" 
                       value="<?= htmlspecialchars($pasien['email'] ?? '') ?>" required>

                <label for="no_telepon">Nomor Telepon</label>
                <input type="text" id="no_telepon" name="no_telepon" 
                       value="<?= htmlspecialchars($pasien['no_telepon'] ?? '') ?>">

                <label for="alamat">Alamat</label>
                <textarea id="alamat" name="alamat" 
                          placeholder="Alamat lengkap..."><?= htmlspecialchars($pasien['alamat'] ?? '') ?></textarea>

                <label for="password">Password Baru (kosongkan jika tidak ingin mengubah)</label>
                <input type="password" id="password" name="password" 
                       placeholder="Masukkan password baru">

                <button type="submit" name="update" class="btn-update">💾 Simpan Perubahan</button>
            </form>
        </div>

        <div class="info-section">
            <h3>Informasi Akun</h3>
            <div class="info-card">
                <p><strong>ID Pasien:</strong> <?= $pasien['id_pasien'] ?? '-' ?></p>
                <p><strong>Tanggal Daftar:</strong> <?= date('d F Y', strtotime($pasien['tanggal_daftar'] ?? date('Y-m-d'))) ?></p>
                <p><strong>Status:</strong> <span style="color: green;">Aktif</span></p>
            </div>
            
            <div class="danger-zone">
                <h4>🏴 Zona Berbahaya</h4>
                <p>Hati-hati dengan tindakan di bawah ini:</p>
                <a href="proses_setting/hapus_akun.php" 
                   onclick="return confirm('Yakin ingin menghapus akun? Tindakan ini tidak dapat dibatalkan!')"
                   class="btn-danger">
                   🗑️ Hapus Akun
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.page-setting {
    padding: 20px;
    max-width: 900px;
    margin: 0 auto;
}

.setting-container {
    display: flex;
    gap: 30px;
    margin-top: 20px;
}

.form-section {
    flex: 2;
    background: #ffffff;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}

.info-section {
    flex: 1;
    background: #ffffff;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.1);
}

.form-section h3, .info-section h3 {
    color: #1c87c9;
    margin-bottom: 20px;
    border-bottom: 2px solid #f0f0f0;
    padding-bottom: 10px;
}

label {
    display: block;
    margin: 15px 0 5px;
    font-weight: 600;
    color: #333;
}

input[type="text"],
input[type="email"],
input[type="password"],
input[type="file"],
textarea,
select {
    width: 100%;
    padding: 10px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 14px;
    transition: border-color 0.3s;
}

input:focus, textarea:focus, select:focus {
    border-color: #1c87c9;
    outline: none;
}

.btn-update {
    background: #1c87c9;
    color: white;
    padding: 12px 25px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-size: 16px;
    margin-top: 20px;
    width: 100%;
    transition: background 0.3s;
}

.btn-update:hover {
    background: #1565a3;
}

.alert {
    padding: 12px;
    border-radius: 8px;
    margin-bottom: 20px;
}

.alert-success {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.alert-error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.info-card {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 20px;
}

.danger-zone {
    border: 2px solid #dc3545;
    padding: 15px;
    border-radius: 8px;
    background: #fff5f5;
}

.danger-zone h4 {
    color: #dc3545;
    margin-bottom: 10px;
}

.btn-danger {
    background: #dc3545;
    color: white;
    padding: 10px 15px;
    border: none;
    border-radius: 6px;
    text-decoration: none;
    display: inline-block;
    margin-top: 10px;
    transition: background 0.3s;
}

.btn-danger:hover {
    background: #c82333;
}

@media (max-width: 768px) {
    .setting-container {
        flex-direction: column;
    }
}
</style>

<?php
$conn->close();
?>