<?php
require_once("../../includes/db_connect.php");
session_start();

if (!isset($_SESSION['id_pasien'])) {
    echo "<script>alert('Silakan login terlebih dahulu!'); window.location.href='../../login.php';</script>";
    exit();
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id_pasien = $_SESSION['id_pasien'];
    $id_layanan = $_POST['id_layanan'];
    $tanggal_janji = $_POST['tanggal'];
    $catatan = $_POST['catatan'];

    $status = 'menunggu';
    $dibuat_pada = date('Y-m-d H:i:s');

    $stmt = $conn->prepare("
        INSERT INTO janji_temu (id_pasien, id_layanan, tanggal_janji, status, catatan, dibuat_pada)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $stmt->bind_param("iissss", $id_pasien, $id_layanan, $tanggal_janji, $status, $catatan, $dibuat_pada);

    if ($stmt->execute()) {
        echo "<script>alert('Janji temu berhasil diajukan!'); window.location.href='../../pasien_layout.php?page=janji_temu';</script>";
    } else {
        echo "<script>alert('Gagal menambah janji temu!'); window.location.href='../../pasien_layout.php?page=janji_temu';</script>";
    }

    $stmt->close();
    $conn->close();
}
?>
