<?php
require_once("../../includes/db_connect.php");
session_start();

if (!isset($_SESSION['id_pasien'])) {
    echo "<script>alert('Silakan login terlebih dahulu!'); window.location.href='../../login.php';</script>";
    exit();
}

if (isset($_GET['id'])) {
    $id_janji = $_GET['id'];
    $id_pasien = $_SESSION['id_pasien'];

    // Pastikan janji milik pasien dan masih bisa dihapus
    $check = $conn->prepare("SELECT status FROM janji_temu WHERE id_janji = ? AND id_pasien = ?");
    $check->bind_param("ii", $id_janji, $id_pasien);
    $check->execute();
    $result = $check->get_result()->fetch_assoc();

    if ($result && $result['status'] === 'menunggu') {
        $stmt = $conn->prepare("DELETE FROM janji_temu WHERE id_janji = ? AND id_pasien = ?");
        $stmt->bind_param("ii", $id_janji, $id_pasien);

        if ($stmt->execute()) {
            echo "<script>alert('Janji temu berhasil dihapus!'); window.location.href='../../pasien_layout.php?page=janji_temu';</script>";
        } else {
            echo "<script>alert('Gagal menghapus janji temu!'); window.location.href='../../pasien_layout.php?page=janji_temu';</script>";
        }

        $stmt->close();
    } else {
        echo "<script>alert('Janji tidak ditemukan atau sudah disetujui!'); window.location.href='../../pasien_layout.php?page=janji_temu';</script>";
    }

    $check->close();
    $conn->close();
}
?>
