<?php
session_start();
include '../includes/db_connect.php';

$id_pasien = $_SESSION['id_pasien'] ?? 0;
if ($id_pasien == 0) {
    header("Location: ../login_pasien.php");
    exit;
}

// 1. Ambil data pasien
$query_pasien = "SELECT nama_pasien FROM data_diri_pasien WHERE id_pasien = ?";
$stmt_pasien = $conn->prepare($query_pasien);
$stmt_pasien->bind_param("i", $id_pasien);
$stmt_pasien->execute();
$result_pasien = $stmt_pasien->get_result();
$pasien = $result_pasien->fetch_assoc();

// 2. Ambil antrian aktif (dari janji temu yang disetujui)
$query_kode = "
    SELECT 
        a.id_antrian,
        a.nomor_antrian,
        a.tanggal,
        a.kode_unik,
        a.created_at,
        j.id_janji,
        j.status as status_janji,
        DATE_FORMAT(a.tanggal, '%W, %d %M %Y') as tanggal_format,
        DATE_FORMAT(a.created_at, '%d/%m/%Y %H:%i') as dibuat_pada
    FROM antrian a
    JOIN janji_temu j ON a.id_janji = j.id_janji
    WHERE j.id_pasien = ? 
    AND j.status = 'disetujui'
    ORDER BY a.created_at DESC
    LIMIT 1
";

$stmt_kode = $conn->prepare($query_kode);
$stmt_kode->bind_param("i", $id_pasien);
$stmt_kode->execute();
$result_kode = $stmt_kode->get_result();
$kode_data = $result_kode->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Pasien - Klinik</title>
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #4895ef;
            --secondary: #3f37c9;
            --success: #4cc9f0;
            --warning: #f72585;
            --light: #f8f9fa;
            --dark: #212529;
            --gray: #6c757d;
            --border: #dee2e6;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }

        body {
            background: #f5f7ff;
            min-height: 100vh;
            padding: 20px;
        }

        .dashboard-container {
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Header Welcome */
        .welcome-header {
            background: white;
            border-radius: 16px;
            padding: 28px;
            margin-bottom: 30px;
            box-shadow: 0 4px 20px rgba(67, 97, 238, 0.1);
            border-left: 6px solid var(--primary);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }

        .welcome-text h1 {
            color: var(--dark);
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .welcome-text h1 span {
            color: var(--primary);
        }

        .welcome-text p {
            color: var(--gray);
            font-size: 15px;
        }

        .patient-id {
            background: var(--primary);
            color: white;
            padding: 10px 20px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* Card Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }

        /* Card Utama - Antrian */
        .card {
            background: white;
            border-radius: 18px;
            overflow: hidden;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
        }

        .card-antrian {
            border-top: 4px solid var(--primary);
        }

        .card-stat {
            border-top: 4px solid var(--success);
        }

        .card-header {
            padding: 24px 24px 0;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 10px;
        }

        .card-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-icon {
            width: 40px;
            height: 40px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .antrian-icon {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .stat-icon {
            background: rgba(76, 201, 240, 0.1);
            color: var(--success);
        }

        /* Nomor Antrian Besar */
        .nomor-antrian-display {
            text-align: center;
            padding: 30px 24px;
            background: linear-gradient(135deg, rgba(67, 97, 238, 0.05) 0%, rgba(67, 97, 238, 0.02) 100%);
            margin: 0 24px;
            border-radius: 12px;
            border: 2px dashed rgba(67, 97, 238, 0.2);
        }

        .nomor-label {
            font-size: 14px;
            color: var(--gray);
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: 600;
        }

        .nomor-value {
            font-size: 64px;
            font-weight: 900;
            color: var(--primary);
            line-height: 1;
            margin: 10px 0;
        }

        .nomor-subtitle {
            color: var(--gray);
            font-size: 14px;
            margin-top: 5px;
        }

        /* Info Box */
        .info-box {
            background: #f8f9ff;
            border-radius: 12px;
            padding: 18px;
            margin: 0 24px 24px;
            border-left: 4px solid var(--primary);
        }

        .info-box p {
            color: var(--dark);
            font-size: 14px;
            line-height: 1.6;
            display: flex;
            align-items: flex-start;
            gap: 10px;
        }

        /* Kode Card Grid */
        .kode-grid {
            padding: 0 24px 24px;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }

        .kode-card {
            background: white;
            border-radius: 10px;
            padding: 18px;
            border: 1px solid var(--border);
            transition: all 0.3s ease;
        }

        .kode-card:hover {
            border-color: var(--primary);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.1);
        }

        .kode-label {
            font-size: 12px;
            color: var(--gray);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 6px;
            font-weight: 600;
        }

        .kode-value {
            font-family: 'Courier New', monospace;
            font-size: 16px;
            font-weight: 700;
            color: var(--dark);
            letter-spacing: 0.5px;
            word-break: break-all;
        }

        .kode-tanggal {
            font-size: 13px;
            color: var(--gray);
            margin-top: 5px;
        }

        /* Tombol Copy */
        .btn-copy-container {
            padding: 0 24px 24px;
        }

        .btn-copy {
            width: 100%;
            padding: 16px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 12px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-copy:hover {
            background: var(--secondary);
            transform: translateY(-2px);
        }

        .btn-copy:active {
            transform: translateY(0);
        }

        /* Card Statistik */
        .stat-content {
            padding: 24px;
        }

        .stat-big-number {
            font-size: 48px;
            font-weight: 800;
            color: var(--success);
            text-align: center;
            margin: 20px 0;
        }

        .stat-description {
            text-align: center;
            color: var(--gray);
            font-size: 15px;
            margin-bottom: 30px;
        }

        .stat-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-top: 20px;
        }

        .stat-item {
            text-align: center;
            padding: 15px;
            background: #f8f9ff;
            border-radius: 10px;
        }

        .stat-number {
            font-size: 24px;
            font-weight: 700;
            color: var(--dark);
            display: block;
            margin-bottom: 5px;
        }

        .stat-label {
            font-size: 13px;
            color: var(--gray);
        }

        /* Tidak Ada Antrian */
        .no-antrian {
            text-align: center;
            padding: 40px 24px;
        }

        .no-antrian-icon {
            font-size: 48px;
            color: var(--gray);
            margin-bottom: 20px;
            opacity: 0.3;
        }

        .no-antrian h4 {
            color: var(--dark);
            margin-bottom: 10px;
            font-size: 18px;
        }

        .no-antrian p {
            color: var(--gray);
            font-size: 14px;
            line-height: 1.6;
        }

        .btn-buat-janji {
            display: inline-block;
            margin-top: 20px;
            padding: 12px 24px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-buat-janji:hover {
            background: var(--secondary);
            transform: translateY(-2px);
        }

        /* Responsif */
        @media (max-widt:768px){
            .welcome-header {
            flex-direction: column;
            text-align: center;
            padding: 20px;
        }

        .cards-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }

        .nomor-value {
            font-size: 48px;
        }

        .kode-grid {
            grid-template-columns: 1fr;
        }

        .stat-details {
            grid-template-columns: 1fr;
        }
        }

        @media (max-widt:480px){body {
            padding: 15px;
        }

        .card-header {
            padding: 20px 20px 0;
        }

        .nomor-antrian-display {
            margin: 0 20px;
            padding: 20px;
        }

        .kode-grid {
            padding: 0 20px 20px;
        }
        }
    </style>
    <style>
    

        .dashboard-container {
            max-width: 800px;
            margin: 0 auto;
        }

        .welcome-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 25px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        }

        .welcome-card h1 {
            color: #333;
            font-size: 24px;
            margin-bottom: 10px;
        }

        .welcome-card p {
            color: #666;
            font-size: 16px;
        }

        .cards-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
        }

        .card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .card-header {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 25px;
        }

        .card-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }

        .card-icon.kode {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .card-icon.stats {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
        }

        .card-title {
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }

        .kode-unik-display {
            text-align: center;
            padding: 25px;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            border-radius: 15px;
            margin: 20px 0;
            border: 2px dashed #667eea;
        }

        .kode-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .kode-value {
            font-family: 'Courier New', monospace;
            font-size: 32px;
            font-weight: 800;
            color: #333;
            letter-spacing: 2px;
        }

        .kode-info {
            font-size: 14px;
            color: #666;
            margin-top: 10px;
        }

        .tanggal-info {
            background: #f8f9ff;
            border-radius: 12px;
            padding: 15px;
            margin-top: 20px;
            border-left: 4px solid #667eea;
        }

        .tanggal-info p {
            color: #555;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .no-kode {
            text-align: center;
            padding: 40px 20px;
        }

        .no-kode-icon {
            font-size: 48px;
            color: #ccc;
            margin-bottom: 20px;
        }

        .no-kode h4 {
            color: #666;
            margin-bottom: 10px;
        }

        .total-number {
            font-size: 48px;
            font-weight: 800;
            text-align: center;
            color: #333;
            margin: 20px 0;
        }

        .total-label {
            text-align: center;
            color: #666;
            font-size: 16px;
        }

        .btn-copy {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 20px;
            transition: all 0.3s ease;
        }

        .btn-copy:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }

        @media (max-width:0768px){.dashboard-container {
            padding: 10px;
        }

        .welcome-card,
        .card {
            padding: 20px;
        }

        .kode-value {
            font-size: 24px;
        }

        .total-number {
            font-size: 36px;
        }
        }
    </style>
</head>

<body>
    <div class="dashboard-container">
        <!-- Header Welcome -->
        <div class="welcome-header">
            <div class="welcome-text">
                <h1>👋 Selamat Datang, <span><?php echo htmlspecialchars($pasien['nama_pasien'] ?? 'Pasien'); ?></span>
                </h1>
                <p>Kelola janji temu dan pantau antrian Anda dengan mudah</p>
            </div>
            <div class="patient-id">
                <span>🆔</span>
                <span>ID: P-<?php echo str_pad($id_pasien, 5, '0', STR_PAD_LEFT); ?></span>
            </div>
        </div>

        <!-- Cards Grid -->
        <div class="cards-grid">
             <div class="cards-container">
                 <!-- Card Kode Unik -->
                 <div class="card">
                     <div class="card-header">
                         <div class="card-icon kode">🔐</div>
                         <div class="card-title">Kode Unik Antrian</div>
                     </div>

                     <?php if($kode_data): ?>
                     <div class="kode-unik-display">
                         <div class="kode-label">Kode Verifikasi Anda</div>
                         <div class="kode-value" id="kodeUnik"><?php echo $kode_data['kode_unik']; ?></div>
                         <div class="kode-info">Tunjukkan kode ini saat tiba di klinik</div>
                     </div>

                     <div class="tanggal-info">
                         <p>📅 Tanggal Janji:
                             <strong><?php echo date('d F Y', strtotime($kode_data['tanggal'])); ?></strong></p>
                         <p>🕐 Dibuat: <?php echo date('d/m/Y H:i', strtotime($kode_data['created_at'])); ?></p>
                     </div>

                     <button id="copyKode" class="btn-copy">
                         📋 Salin Kode Unik
                     </button>
                     <?php else: ?>
                     <div class="no-kode">
                         <div class="no-kode-icon">📭</div>
                         <h4>Belum Ada Kode Unik</h4>
                         <p>Anda belum memiliki janji temu yang disetujui.</p>
                     </div>
                     <?php endif; ?>
                 </div>

             </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            // Copy Access Code
            const copyBtn = document.getElementById("copyAccessCode");

            if (copyBtn) {
                copyBtn.addEventListener("click", function () {
                    const accessCode = document.getElementById("accessCode").textContent;

                    navigator.clipboard.writeText(accessCode)
                        .then(() => {
                            const originalText = copyBtn.innerHTML;
                            copyBtn.innerHTML = "✅ Berhasil Disalin!";
                            copyBtn.style.background = "var(--success)";

                            setTimeout(() => {
                                copyBtn.innerHTML = originalText;
                                copyBtn.style.background = "";
                            }, 2000);
                        })
                        .catch(err => {
                            console.error("Gagal menyalin: ", err);
                            alert("Gagal menyalin ke clipboard");
                        });
                });
            }

            // Auto-refresh data antrian setiap 1 menit
            function refreshAntrianData() {
                fetch("proses_dashboard/refresh_antrian.php")
                    .then(res => res.json())
                    .then(data => {
                        if (data.hasNewData) {
                            // Jika ada update, reload halaman
                            location.reload();
                        }
                    })
                    .catch(err => console.error("Refresh error:", err));
            }

            // Jalankan refresh setiap 60 detik
            setInterval(refreshAntrianData, 60000);
        });
    </script>
</body>

</html>