<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Klinik Gigi Anak - Tempat perawatan gigi yang menyenangkan dan ramah anak untuk kesehatan gigi si kecil">
    <meta name="keywords" content="klinik gigi anak, perawatan gigi anak, dokter gigi anak, kesehatan gigi anak">
    <title>Klinik Gigi Tumbuh Kembang Pratama - Senyum Ceria, Gigi Sehat!</title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* Base Styles & Variables */
        :root {
          --ungu: #b99ff9;
          --ungu-tua: #8d6cf2;
          --mint: #b8f1dc;
          --pink: #ffd7e2;
          --putih: #ffffff;
          --abu: #fafafa;
          --teks: #594f75;
          --shadow-light: rgba(0, 0, 0, 0.08);
          --shadow-medium: rgba(0, 0, 0, 0.12);
          --shadow-strong: rgba(0, 0, 0, 0.18);
          font-family: 'Fredoka', 'Poppins', sans-serif;
          scroll-behavior: smooth;
        }

        * {
          box-sizing: border-box;
        }

        body {
          margin: 0;
          padding: 0;
          background: var(--abu);
          color: var(--teks);
          overflow-x: hidden;
          line-height: 1.6;
        }

        section {
          padding: 80px 20px;
          text-align: center;
          position: relative;
          z-index: 1;
        }

        h1, h2, h3, h4 {
          margin: 10px 0 20px;
          font-family: 'Fredoka', sans-serif;
          color: var(--ungu-tua);
          line-height: 1.2;
        }

        h1 {
          font-size: 3em;
        }

        h2 {
          font-size: 2.5em;
          margin-bottom: 30px;
        }

        h3 {
          font-size: 1.8em;
        }

        p {
          font-family: 'Poppins', sans-serif;
        }

        a {
          text-decoration: none;
        }

        /* Global Button Style */
        .btn-primary {
          background: var(--ungu-tua);
          color: var(--putih);
          border: none;
          border-radius: 30px;
          padding: 14px 32px;
          font-weight: 600;
          font-size: 1.1em;
          cursor: pointer;
          box-shadow: 0 6px 15px var(--shadow-light);
          transition: all 0.3s ease;
          letter-spacing: 0.5px;
          display: inline-block;
          margin-top: 25px;
        }

        .btn-primary:hover {
          transform: translateY(-3px);
          box-shadow: 0 10px 20px var(--shadow-medium);
          background: #7a5ce0;
        }

        .btn-secondary {
          background: var(--putih);
          color: var(--ungu-tua);
          border: 2px solid var(--ungu-tua);
          border-radius: 30px;
          padding: 14px 32px;
          font-weight: 600;
          font-size: 1.1em;
          cursor: pointer;
          box-shadow: 0 4px 10px var(--shadow-light);
          transition: all 0.3s ease;
          letter-spacing: 0.5px;
          display: inline-block;
          margin-top: 25px;
        }

        .btn-secondary:hover {
          transform: translateY(-3px);
          box-shadow: 0 8px 15px var(--shadow-medium);
          background: var(--ungu-tua);
          color: var(--putih);
        }

        /* ===== Header & Navigation ===== */
        .header-nav {
          position: fixed;
          width: 100%;
          background: var(--putih);
          box-shadow: 0 2px 10px var(--shadow-light);
          z-index: 1000;
          padding: 15px 30px;
          display: flex;
          justify-content: space-between;
          align-items: center;
        }

        .header-nav .logo {
          font-family: 'Fredoka', sans-serif;
          font-size: 1.8em;
          font-weight: 700;
          color: var(--ungu-tua);
        }

        .header-nav .nav-links {
          display: flex;
          align-items: center;
        }

        .header-nav .nav-links a {
          color: var(--teks);
          margin-left: 30px;
          font-weight: 500;
          transition: color 0.3s ease;
        }

        .header-nav .nav-links a:hover {
          color: var(--ungu);
        }

        .header-nav .nav-links .btn-primary {
          margin-top: 0;
          margin-left: 20px;
          padding: 8px 20px;
          font-size: 0.9em;
        }

        .mobile-menu-toggle {
          display: none;
          flex-direction: column;
          background: none;
          border: none;
          cursor: pointer;
          padding: 5px;
        }

        .mobile-menu-toggle span {
          width: 25px;
          height: 3px;
          background: var(--ungu-tua);
          margin: 3px 0;
          transition: 0.3s;
        }

        /* ===== Hero ===== */
    .hero {
  background: 
    linear-gradient(180deg, rgba(132, 78, 255, 0.45) 0%, rgba(255, 255, 255, 0.65) 100%),
    url(assets/img/aneh.png) no-repeat center center / cover;
  background-attachment: fixed;
  border-bottom-left-radius: 60% 15%;
  border-bottom-right-radius: 60% 15%;
  padding: 150px 20px 180px;
  position: relative;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  min-height: 100vh;
  color: var(--putih);
  text-align: center;
  overflow: hidden;
  z-index: 1;
}

        .hero-content {
          max-width: 800px;
          z-index: 2;
        }

        .hero h1 {
          font-size: 3.8em;
          color: var(--putih);
          text-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
          margin-bottom: 30px;
          font-weight: 700;
        }

        .hero p {
          font-size: 1.3em;
          color: var(--putih);
          margin-bottom: 40px;
          font-weight: 300;
        }

        .hero .btn-primary {
          background: var(--putih);
          color: var(--ungu-tua);
          box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }

        .hero .btn-primary:hover {
          background: var(--ungu-tua);
          color: var(--putih);
        }

        /* Bunny Animation */
        /* ===== Bunny ===== */
.bunny {
  position: absolute;
  bottom: 0;
  left: 50%;
  transform: translateX(-50%);
  width: 150px;
  height: 150px;
  background: var(--putih);
  border-radius: 50%; /* bulat penuh */
  box-shadow: inset 0 -6px 0 rgba(0,0,0,0.1), 0 10px 20px rgba(0,0,0,0.15);
  animation: hop 3s ease-in-out infinite;
  z-index: 2;
}

/* Telinga lentur */
.bunny::before, .bunny::after {
  content: "";
  position: absolute;
  width: 25px;
  height: 60px;
  background: var(--putih);
  border-radius: 50% 50% 45% 45%;
  top: -30px;
  transform-origin: bottom center;
  animation: earWiggle 2s ease-in-out infinite alternate;
  box-shadow: inset 0 -3px 0 rgba(0,0,0,0.08);
}

.bunny::before { left: 25px; transform: rotate(-10deg); }
.bunny::after  { right: 25px; transform: rotate(10deg); }

/* Bunny face */
.bunny-face {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  width: 60px;
  height: 40px;
  background: transparent;
}

/* Mata */
.bunny-face::before, .bunny-face::after {
  content: '';
  position: absolute;
  width: 8px;
  height: 8px;
  background: var(--teks);
  border-radius: 50%;
  top: 10px;
}

.bunny-face::before { left: 10px; }
.bunny-face::after { right: 10px; }

/* Animasi hop */
@keyframes hop {
  0%, 100% {
    transform: translateX(-50%) translateY(0);
  }
  50% {
    transform: translateX(-50%) translateY(-20px);
  }
}

/* Animasi telinga goyang */
@keyframes earWiggle {
  0% { transform: rotate(-10deg); }
  50% { transform: rotate(-25deg); }
  100% { transform: rotate(-10deg); }
}

.bunny::after {
  animation-name: earWiggle;
}


        /* ===== Jadwal (Schedule) ===== */
        .schedule {
          background: var(--mint);
          border-radius: 40px;
          margin: -80px auto 60px;
          max-width: 1000px;
          padding: 50px 30px;
          box-shadow: 0 12px 30px var(--shadow-medium);
          z-index: 5;
          position: relative;
        }

        .schedule h2 {
          color: var(--ungu-tua);
          margin-bottom: 40px;
        }

        .schedule .cards {
          display: flex;
          flex-wrap: wrap;
          justify-content: center;
          gap: 30px;
        }

        .card {
          background: var(--putih);
          border-radius: 25px;
          padding: 30px;
          width: 220px;
          box-shadow: 0 8px 20px var(--shadow-light);
          transition: transform 0.3s ease, box-shadow 0.3s ease;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
        }

        .card:hover {
          transform: translateY(-10px) rotate(1deg);
          box-shadow: 0 15px 30px var(--shadow-medium);
        }

        .card h3 {
          color: var(--ungu-tua);
          margin-bottom: 10px;
          font-size: 1.6em;
        }

        .card p {
          font-size: 1.1em;
          color: var(--teks);
        }

        /* ===== Layanan (Services) ===== */
        .services {
          background: linear-gradient(180deg, var(--putih) 0%, var(--pink) 100%);
          padding-bottom: 100px;
        }

        .services h2 {
          color: var(--ungu-tua);
          margin-bottom: 50px;
        }

        .services .service-list {
          display: flex;
          flex-wrap: wrap;
          justify-content: center;
          gap: 40px;
          margin-top: 40px;
        }

        .service-item {
          width: 180px;
          height: 180px;
          background: var(--putih);
          border-radius: 50%;
          box-shadow: 0 8px 20px var(--shadow-light);
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
          transition: transform 0.3s ease, box-shadow 0.3s ease;
          cursor: pointer;
          position: relative;
          overflow: hidden;
        }

        .service-item:hover {
          transform: scale(1.08);
          box-shadow: 0 15px 30px var(--shadow-medium);
        }

        .service-item span {
          font-weight: 600;
          color: var(--ungu-tua);
          font-size: 1.1em;
          text-align: center;
          z-index: 2;
          position: relative;
        }

        .service-item::before {
          content: '';
          position: absolute;
          top: -30%;
          left: -30%;
          width: 100%;
          height: 100%;
          background: var(--mint);
          border-radius: 50%;
          transform: scale(0.6);
          opacity: 0.3;
          transition: transform 0.3s ease;
        }

        .service-item:nth-child(even)::before {
          background: var(--pink);
        }

        .service-item:hover::before {
          transform: scale(0.8);
          opacity: 0.5;
        }

        /* ===== Fun Space ===== */
        .fun {
          background: var(--mint);
          border-top-left-radius: 60px;
          border-top-right-radius: 60px;
          padding-bottom: 100px;
        }

        .fun h2 {
          color: var(--ungu-tua);
        }

        .bubble {
          background: var(--putih);
          border-radius: 40px;
          padding: 25px 40px;
          display: inline-block;
          position: relative;
          box-shadow: 0 6px 15px var(--shadow-light);
          font-size: 1.1em;
          font-weight: 500;
          margin-bottom: 30px;
          max-width: 600px;
        }

        .bubble::after {
          content: "";
          position: absolute;
          bottom: -20px;
          left: 50%;
          transform: translateX(-50%);
          border: 20px solid transparent;
          border-top-color: var(--putih);
        }

        .video-container {
          margin-top: 40px;
          display: flex;
          justify-content: center;
        }

        .fun iframe {
          border-radius: 25px;
          width: min(90%, 800px);
          height: min(50vw, 450px);
          border: none;
          box-shadow: 0 10px 25px var(--shadow-medium);
        }

        /* ===== News ===== */
        .news {
          background: linear-gradient(180deg, var(--pink) 0%, var(--putih) 100%);
          padding-bottom: 80px;
        }

        .news h2 {
          color: var(--ungu-tua);
          margin-bottom: 40px;
        }

        .news-container {
          display: flex;
          overflow-x: auto;
          gap: 30px;
          padding: 20px;
          scroll-snap-type: x mandatory;
          -webkit-overflow-scrolling: touch;
          scrollbar-width: none;
        }

        .news-container::-webkit-scrollbar {
          display: none;
        }

        .news-card {
          flex: 0 0 auto;
          background: var(--putih);
          border-radius: 25px;
          width: 300px;
          padding: 30px;
          scroll-snap-align: start;
          box-shadow: 0 8px 20px var(--shadow-light);
          transition: transform 0.3s ease, box-shadow 0.3s ease;
          text-align: left;
        }

        .news-card:hover {
          transform: translateY(-8px);
          box-shadow: 0 15px 30px var(--shadow-medium);
        }

        .news-card h3 {
          font-size: 1.5em;
          color: var(--ungu-tua);
          margin-bottom: 10px;
        }

        .news-card p {
          font-size: 0.95em;
          color: var(--teks);
        }

        .news-card a {
          color: var(--ungu-tua);
          font-weight: 600;
          margin-top: 15px;
          display: inline-block;
          font-size: 0.9em;
        }

        .news-card a:hover {
          text-decoration: underline;
        }

        /* ===== Testimoni (Testimonials) ===== */
        .testimoni {
          background: var(--abu);
          padding-bottom: 100px;
        }

        .testimoni h2 {
          color: var(--ungu-tua);
          margin-bottom: 50px;
        }

        .testi-list {
          display: flex;
          flex-wrap: wrap;
          justify-content: center;
          gap: 30px;
          margin-top: 30px;
        }

        .testi {
          background: var(--putih);
          border-radius: 35px;
          padding: 30px;
          width: 280px;
          box-shadow: 0 8px 20px var(--shadow-light);
          transition: transform 0.3s ease, box-shadow 0.3s ease;
          text-align: center;
        }

        .testi:hover {
          transform: translateY(-12px);
          box-shadow: 0 15px 30px var(--shadow-medium);
        }

        .testi p {
          font-style: italic;
          font-size: 1.1em;
          color: var(--teks);
          margin-bottom: 15px;
        }

        .testi strong {
          display: block;
          margin-top: 10px;
          color: var(--ungu-tua);
          font-weight: 600;
          font-size: 1.05em;
        }

        /* ===== Footer ===== */
        footer {
          background: var(--ungu-tua);
          color: var(--putih);
          padding: 60px 20px 40px;
          border-top-left-radius: 40px;
          border-top-right-radius: 40px;
          text-align: center;
        }

        footer h3 {
          color: var(--putih);
          margin-bottom: 30px;
          font-size: 2em;
        }

        footer .social-links {
          margin-bottom: 30px;
        }

        footer .social-links a {
          color: var(--putih);
          margin: 0 15px;
          display: inline-flex;
          align-items: center;
          background: rgba(255, 255, 255, 0.15);
          padding: 12px 20px;
          border-radius: 30px;
          transition: background 0.3s ease, transform 0.3s ease;
          font-weight: 500;
        }

        footer .social-links a:hover {
          background: rgba(255, 255, 255, 0.3);
          transform: translateY(-5px);
        }

        .map-container {
          display: flex;
          justify-content: center;
          margin-top: 30px;
        }

        iframe.map {
          width: min(90%, 900px);
          height: 300px;
          border: none;
          border-radius: 25px;
          box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }

        footer p {
          margin-top: 40px;
          font-size: 0.9em;
          opacity: 0.8;
        }

        /* Responsive Adjustments */
        @media (max-width: 768px) {
          h1 {
            font-size: 2.5em;
          }
          
          h2 {
            font-size: 2em;
          }
          
          section {
            padding: 60px 15px;
          }
          
          .hero {
            padding: 120px 15px 150px;
          }
          
          .hero h1 {
            font-size: 2.8em;
          }
          
          .hero p {
            font-size: 1.1em;
          }
          
          .schedule {
            margin: -60px auto 40px;
            padding: 40px 20px;
          }
          
          .schedule .cards, .services .service-list, .testi-list {
            flex-direction: column;
            align-items: center;
          }
          
          .card, .service-item, .testi, .news-card {
            width: 90%;
            max-width: 350px;
          }
          
          .news-container {
            padding: 10px;
          }
          
          .bunny {
            width: 100px;
            height: 130px;
          }
          
          .bunny::before, .bunny::after {
            width: 30px;
            height: 70px;
            top: -45px;
          }
          
          .fun iframe, iframe.map {
            height: 250px;
          }
          
          .header-nav .nav-links {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            width: 100%;
            background: var(--putih);
            flex-direction: column;
            padding: 20px;
            box-shadow: 0 5px 10px var(--shadow-light);
          }
          
          .header-nav .nav-links.active {
            display: flex;
          }
          
          .header-nav .nav-links a {
            margin: 10px 0;
          }
          
          .mobile-menu-toggle {
            display: flex;
          }
          
          .mobile-menu-toggle.active span:nth-child(1) {
            transform: rotate(-45deg) translate(-5px, 6px);
          }
          
          .mobile-menu-toggle.active span:nth-child(2) {
            opacity: 0;
          }
          
          .mobile-menu-toggle.active span:nth-child(3) {
            transform: rotate(45deg) translate(-5px, -6px);
          }
        }

        @media (max-width: 480px) {
          h1 {
            font-size: 2em;
          }
          
          h2 {
            font-size: 1.8em;
          }
          
          .hero h1 {
            font-size: 2.2em;
          }
          
          .hero p {
            font-size: 1em;
          }
          
          .btn-primary, .btn-secondary {
            padding: 10px 25px;
            font-size: 1em;
          }
          
          .bubble {
            padding: 20px 30px;
            font-size: 1em;
          }
          
          .bunny {
            left: 20%;
            transform: translateX(0);
          }
        }
    </style>
</head>
<body>
    <!-- Header & Navigation -->
    <header class="header-nav" role="banner">
        <div class="logo">Klinik Tumbuh Kembang Pratama</div>
        <nav class="nav-links" role="navigation">
            <a href="#schedule">Jadwal</a>
            <a href="#services">Layanan</a>
            <a href="#fun">Fun Space</a>
            <a href="#news">Berita</a>
            <a href="#testimoni">Testimoni</a>
            <button class="btn-primary" onclick="location.href='login_pasien.php'" aria-label="Login ke sistem">Login</button>
        </nav>
        <button class="mobile-menu-toggle" aria-label="Toggle mobile menu">
            <span></span>
            <span></span>
            <span></span>
        </button>
    </header>

    <!-- Hero Section -->
    <section class="hero" role="main">
        <div class="hero-content">

            <h1>Senyum Ceria, Gigi Sehat!</h1>
            <p>Tempat favorit anak-anak untuk perawatan gigi yang menyenangkan dan tanpa rasa takut.</p>
            <button class="btn-primary" onclick="location.href='index.php'">Book Now</button>
        </div>
        <div class="bunny" aria-hidden="true">
            <div class="bunny-face"></div>
        </div>
    </section>

    <!-- Schedule Section -->
<section id="schedule" class="schedule" role="region" aria-labelledby="schedule-heading">
  <h2 id="schedule-heading">Jadwal Klinik</h2>
  <div class="schedule-table">
    <div class="schedule-card side">
      <h3>Booking Online</h3>
      <p>Mudah & cepat</p>
      <button class="btn-secondary" onclick="location.href='index.php'">Book Now</button>
    </div>

    <table class="schedule-card center">
      <thead>
        <tr><th>Hari</th><th>Pagi</th><th>Sore</th></tr>
      </thead>
      <tbody>
        <tr><td>Senin</td><td>09.00–12.00</td><td>16.00–18.00</td></tr>
        <tr><td>Selasa</td><td>09.00–12.00</td><td>16.00–18.00</td></tr>
        <tr><td>Rabu</td><td>09.00–12.00</td><td>16.00–18.00</td></tr>
        <tr><td>Kamis</td><td>09.00–12.00</td><td>16.00–18.00</td></tr>
        <tr><td>Jumat</td><td>09.00–12.00</td><td>16.00–18.00</td></tr>
        <tr><td>Sabtu</td><td>09.00–12.00</td><td>-</td></tr>
        <tr><td>Minggu</td><td colspan="2">Tutup</td></tr>
      </tbody>
    </table>

    <div class="schedule-card side">
      <h3>Walk-in Welcome!</h3>
      <p>Silakan datang langsung ke klinik, prioritas sesuai antrean</p>
    </div>
  </div>
</section>

<style>
/* Schedule Section Custom */
.schedule-table {
  display: flex;
  justify-content: center;
  align-items: flex-start;
  gap: 20px;
  flex-wrap: wrap;
}

.schedule-card {
  border-radius: 25px;
  padding: 25px;
  box-shadow: 0 8px 20px rgba(0,0,0,0.08);
}

.schedule-card.side {
  background: var(--putih);
  text-align: center;
  flex: 1 1 200px;
}

.schedule-card.side .btn-secondary {
  margin-top: 15px;
}

.schedule-card.center {
  background: var(--pink);
  color: var(--ungu-tua);
  flex: 1 1 300px;
  min-width: 250px;
}

.schedule-card.center table {
  width: 100%;
  border-collapse: collapse;
  text-align: center;
  font-weight: 500;
}

.schedule-card.center th,
.schedule-card.center td {
  padding: 10px;
  border-bottom: 1px solid rgba(0,0,0,0.1);
}

.schedule-card.center th {
  font-size: 1.1em;
}

.schedule-card.center tr:last-child td {
  border-bottom: none;
}

@media (max-width: 768px) {
  .schedule-table {
    flex-direction: column;
    align-items: center;
  }
}
</style>



    <!-- Services Section -->
    <section id="services" class="services" role="region" aria-labelledby="services-heading">
        <h2 id="services-heading">Layanan Ramah Anak</h2>
        <div class="service-list">
            <div class="service-item"><span>Pembersihan Gigi</span></div>
            <div class="service-item"><span>Tambal Gigi</span></div>
            <div class="service-item"><span>Perawatan Ortodonti</span></div>
            <div class="service-item"><span>Konsultasi Anak</span></div>
            <div class="service-item"><span>Fluoridasi</span></div>
            <div class="service-item"><span>Pencabutan Gigi Susu</span></div>
        </div>
    </section>

    <!-- Fun Space Section -->
    <section id="fun" class="fun" role="region" aria-labelledby="fun-heading">
        <h2 id="fun-heading">Area Bermain & Edukasi 🐰</h2>
        <div class="bubble">Hai, yuk nonton video seru dan belajar cara merawat gigi bareng GIGI si kelinci!</div>
        <div class="video-container">
            <iframe src="https://www.instagram.com/reel/DN7EbD4EyY5/" title="Video Edukasi Gigi Anak" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
    </section>

    <!-- News Section -->
    <section id="news" class="news" role="region" aria-labelledby="news-heading">
        <h2 id="news-heading">Berita & Kegiatan Terbaru</h2>
        <div class="news-container">
            <div class="news-card">
                <h3>Pemeriksaan Gratis</h3>
                <p>Jangan lewatkan event seru pemeriksaan gigi gratis minggu depan di SD Ceria!</p>
                <a href="#">Baca Selengkapnya →</a>
            </div>
            <div class="news-card">
                <h3>Tips Gigi Sehat</h3>
                <p>Cek blog terbaru kami: "5 Cara Asyik Agar Anak Berani Sikat Gigi Setiap Hari!"</p>
                <a href="#">Baca Blog →</a>
            </div>
            <div class="news-card">
                <h3>Kunjungan Edukasi</h3>
                <p>Klinik GIGI senang sekali berkunjung ke TK Pelangi, mengajarkan cara sikat gigi yang benar!</p>
                <a href="#">Lihat Galeri →</a>
            </div>
            <div class="news-card">
                <h3>Promo Liburan</h3>
                <p>Diskon spesial 20% untuk paket pembersihan dan fluoridasi selama liburan sekolah!</p>
                <a href="#">Lihat Promo →</a>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section id="testimoni" class="testimoni" role="region" aria-labelledby="testimoni-heading">
        <h2 id="testimoni-heading">Apa Kata Orang Tua?</h2>
        <div class="testi-list">
            <div class="testi">
                <p>"Anakku senang banget ke sini, staffnya ramah semua dan dokternya sabar banget!"</p>
                <strong>- Ibu Lina, Jakarta</strong>
            </div>
            <div class="testi">
                <p>"Dekorasi kliniknya lucu dan warna-warni, anakku jadi nggak takut periksa gigi lagi!"</p>
                <strong>- Bapak Dimas, Tangerang</strong>
            </div>
            <div class="testi">
                <p>"Kliniknya bersih, nyaman, dan paling penting, anak-anak betah berlama-lama di sini 💜"</p>
                <strong>- Ibu Sari, Bekasi</strong>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <h3>Hubungi Kami</h3>
        <div class="social-links">
            <a href="https://wa.me/6281234567890" target="_blank" aria-label="Hubungi kami via WhatsApp">WhatsApp</a>
            <a href="mailto:info@klinikgigi.com" aria-label="Kirim email kepada kami">Email</a>
            <a href="#" target="_blank" aria-label="Kunjungi Instagram kami">Instagram</a>
        </div>
        <div class="map-container">
           <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3960.1313718444626!2d110.43122487401868!3d-6.993804768493155!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e708caefa5913bf%3A0xf19852b82670be43!2sTumbuh%20Kembang%20Pratama%20Dental%20Care!5e0!3m2!1sid!2sid!4v1760295510461!5m2!1sid!2sid" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
        <p>&copy; 2025 Klinik GIGI Anak. Semua Hak Dilindungi.</p>
    </footer>

    <!-- JavaScript -->
    <script>
        // Mobile menu toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
            const navLinks = document.querySelector('.nav-links');
            
            if (mobileMenuToggle) {
                mobileMenuToggle.addEventListener('click', function() {
                    navLinks.classList.toggle('active');
                    mobileMenuToggle.classList.toggle('active');
                });
            }
            
            // Close mobile menu when clicking on a link
            const navLinksItems = document.querySelectorAll('.nav-links a');
            navLinksItems.forEach(link => {
                link.addEventListener('click', function() {
                    navLinks.classList.remove('active');
                    mobileMenuToggle.classList.remove('active');
                });
            });
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
        });
    </script>
</body>
</html>