document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("formNotif");
  const tbody = document.getElementById("dataNotif");

  loadNotif();

  // Baca semua template
  function loadNotif() {
    fetch("../admin/template_notifikasi_action.php?action=read")
      .then((res) => res.json())
      .then((data) => {
        tbody.innerHTML = "";
        if (data.length === 0) {
          tbody.innerHTML = `<tr><td colspan="5" align="center">Belum ada template 💌</td></tr>`;
        } else {
          data.forEach((item, index) => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
              <td>${index + 1}</td>
              <td>${item.judul}</td>
              <td>${item.kategori}</td>
              <td>${item.isi.substring(0, 50)}...</td>
              <td>
                <button class="btn-edit" data-id="${
                  item.id
                }"><i class="bx bx-edit"></i></button>
                <button class="btn-delete" data-id="${
                  item.id
                }"><i class="bx bx-trash"></i></button>
              </td>
            `;
            tbody.appendChild(tr);
          });
        }
      });
  }

  // Simpan / Update
  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const formData = new FormData(form);
    fetch("../admin/template_notifikasi_action.php?action=save", {
      method: "POST",
      body: formData,
    })
      .then((res) => res.text())
      .then((msg) => {
        alert(msg);
        form.reset();
        loadNotif();
      });
  });

  // Edit & Hapus
  tbody.addEventListener("click", (e) => {
    const editBtn = e.target.closest(".btn-edit");
    const deleteBtn = e.target.closest(".btn-delete");

    if (editBtn) {
      const id = editBtn.dataset.id;
      fetch(`../admin/template_notifikasi_action.php?action=get&id=${id}`)
        .then((res) => res.json())
        .then((data) => {
          document.getElementById("notif_id").value = data.id;
          document.getElementById("judul").value = data.judul;
          document.getElementById("kategori").value = data.kategori;
          document.getElementById("isi").value = data.isi;
        });
    }

    if (deleteBtn) {
      const id = deleteBtn.dataset.id;
      if (confirm("Hapus template ini?")) {
        fetch(`../admin/template_notifikasi_action.php?action=delete&id=${id}`)
          .then((res) => res.text())
          .then((msg) => {
            alert(msg);
            loadNotif();
          });
      }
    }
  });
});
