// assets/js/kelola_user_crud.js
document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("formUser");
  const tbody = document.getElementById("tableUsers");
  const linkedType = document.getElementById("linked_type");
  const linkedId = document.getElementById("linked_id");

  loadUsers();
  loadCandidates(); // load empty / defaults

  linkedType.addEventListener("change", () => {
    loadCandidates(linkedType.value);
  });

  function loadCandidates(type = "") {
    linkedId.innerHTML = `<option value="">-- Pilih --</option>`;
    if (!type) return;
    fetch(`../admin/user_action.php?action=list_candidates&type=${type}`)
      .then((r) => r.json())
      .then((data) => {
        data.forEach((it) => {
          const opt = document.createElement("option");
          opt.value = it.id;
          opt.textContent = `${it.nama} ${
            it.email ? "(" + it.email + ")" : ""
          }`;
          linkedId.appendChild(opt);
        });
      });
  }

  function loadUsers() {
    fetch("../admin/user_action.php?action=read")
      .then((r) => r.json())
      .then((data) => {
        tbody.innerHTML = "";
        if (!data.length) {
          tbody.innerHTML = `<tr><td colspan="5" align="center">Belum ada user.</td></tr>`;
          return;
        }
        data.forEach((u, i) => {
          const tr = document.createElement("tr");
          tr.innerHTML = `
            <td>${i + 1}</td>
            <td>${u.email}</td>
            <td>${u.role}</td>
            <td>${
              u.linked_type
                ? u.linked_type + " : " + (u.linked_name ?? "-")
                : "-"
            }</td>
            <td>
              <button class="btn-edit" data-id="${u.id_user}">Edit</button>
              <button class="btn-delete" data-id="${u.id_user}">Hapus</button>
            </td>
          `;
          tbody.appendChild(tr);
        });
      });
  }

  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const fd = new FormData(form);
    fetch("../admin/user_action.php?action=save", { method: "POST", body: fd })
      .then((r) => r.text())
      .then((msg) => {
        alert(msg);
        form.reset();
        loadUsers();
      });
  });

  tbody.addEventListener("click", (e) => {
    const edit = e.target.closest(".btn-edit");
    const del = e.target.closest(".btn-delete");
    if (edit) {
      const id = edit.dataset.id;
      fetch(`../admin/user_action.php?action=get&id=${id}`)
        .then((r) => r.json())
        .then((u) => {
          document.getElementById("id_user").value = u.id_user;
          document.getElementById("u_email").value = u.email;
          document.getElementById("u_password").value = ""; // kosongkan
          document.getElementById("u_role").value = u.role;
          document.getElementById("linked_type").value = u.linked_type ?? "";
          loadCandidates(u.linked_type ?? "");
          setTimeout(() => {
            document.getElementById("linked_id").value = u.linked_id ?? "";
          }, 200);
        });
    }
    if (del) {
      if (!confirm("Hapus akun?")) return;
      fetch(`../admin/user_action.php?action=delete&id=${del.dataset.id}`)
        .then((r) => r.text())
        .then((msg) => {
          alert(msg);
          loadUsers();
        });
    }
  });
});
