<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<!-- admin/kelola_user.php -->
<div class="page-users">
    <h2>🔐 Kelola User</h2>
    <p>Buat / edit akun admin, dokter, atau pasien (link ke pegawai/pasien jika perlu).</p>

    <div class="user-container">
        <div class="user-form">
            <h3>Tambah / Edit User</h3>
            <form id="formUser">
                <input type="hidden" id="id_user" name="id_user" value="">
                <label>Email</label>
                <input type="email" id="u_email" name="email" required>

                <label>Password <small>(kosongkan saat edit jika tidak ingin mengganti)</small></label>
                <input type="password" id="u_password" name="password">

                <label>Role</label>
                <select id="u_role" name="role" required>
                    <option value="admin">Admin</option>
                    <option value="dokter">Dokter</option>
                    <option value="pasien">Pasien</option>
                </select>

                <label>Terhubung dengan</label>
                <select id="linked_type" name="linked_type">
                    <option value="">-- Tidak terhubung --</option>
                    <option value="pegawai">Pegawai</option>
                    <option value="pasien">Pasien</option>
                </select>

                <label>Jika terhubung, pilih</label>
                <select id="linked_id" name="linked_id">
                    <option value="">-- Pilih --</option>
                </select>

                <button type="submit" class="btn-save">Simpan</button>
            </form>
        </div>

        <div class="user-list">
            <h3>Daftar Akun</h3>
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Linked</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="tableUsers"></tbody>
            </table>
        </div>
    </div>
</div>

<script src="../assets/js/kelola_user_crud.js"></script>
