<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<?php
require_once("../includes/db_connect.php"); 

$query = "SELECT * FROM jenis_layanan ORDER BY id_layanan DESC";
$result = $conn->query($query);
?>

<div class="page-layanan">
    <h2>🧩 Jenis Layanan</h2>
    <p>Kelola berbagai layanan yang tersedia di Klinik Gigi Anak Ceria 💖</p>

    <div class="layanan-container">
        <!-- Form Tambah Layanan -->
        <div class="layanan-form">
            <h3><i class="bx bx-plus-circle"></i> Tambah Layanan Baru</h3>
            <form id="formLayanan">
                <label>Nama Layanan:</label>
                <input type="text" name="nama_layanan" placeholder="Contoh: Tambal Gigi Susu" required>

                <label>Deskripsi:</label>
                <textarea name="deskripsi" placeholder="Tuliskan deskripsi singkat..." required></textarea>

                <button type="submit" class="btn-save"><i class="bx bx-save"></i> Simpan</button>
            </form>
        </div>

        <!-- Daftar Layanan -->
        <div class="layanan-list">
            <h3><i class="bx bx-list-ul"></i> Daftar Layanan</h3>
            <table>
                <thead>
                    <tr>
                        <th>Nama Layanan</th>
                        <th>Deskripsi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="layananData">
                    <?php
                    // Fetch the next row of a result set as an associative array
                    while ($res = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>".$res['nama_layanan']."</td>";
                        echo "<td>".$res['deskripsi']."</td>";
                        echo "<td><a href=\"proses_stok/edit.php?id=$res[id_layanan]\">Edit</a> | 
                        <a href=\"delete.php?id=$res[id_layanan]\" onClick=\"return confirm('Are you sure you want to delete?')\">Delete</a></td>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    const formLayanan = document.getElementById('formLayanan');
    const tableLayanan = document.getElementById('layananData');

    formLayanan.addEventListener('submit', (e) => {
        e.preventDefault();
        const nama = formLayanan.nama_layanan.value;
        const desc = formLayanan.deskripsi.value;
        const harga = formLayanan.harga.value;

        const newRow = document.createElement('tr');
        newRow.innerHTML = `
      <td>${tableLayanan.rows.length + 1}</td>
      <td>${nama}</td>
      <td>${desc}</td>
      <td>Rp ${parseInt(harga).toLocaleString()}</td>
      <td>
        <button class="btn-edit"><i class="bx bx-edit"></i></button>
        <button class="btn-delete"><i class="bx bx-trash"></i></button>
      </td>
    `;
        tableLayanan.appendChild(newRow);
        formLayanan.reset();
    });

    document.addEventListener('click', (e) => {
        if (e.target.closest('.btn-delete')) {
            e.target.closest('tr').remove();
        }
    });
</script>
