<?php
session_start();
if(!isset($_SESSION['id_admin'])){
    exit();
}

require_once("../includes/db_connect.php");

if(isset($_GET['id_rekam'])) {
    $id_rekam = intval($_GET['id_rekam']);
    
    $query = "SELECT 
                rm.*,
                p.nama_pasien,
                p.tanggal_lahir,
                p.jenis_kelamin,
                l.nama_layanan,
                pg.nama_pegawai,
                pg.spesialisasi
              FROM rekam_medis rm
              LEFT JOIN data_diri_pasien p ON rm.id_pasien = p.id_pasien
              LEFT JOIN jenis_layanan l ON rm.id_layanan = l.id_layanan
              LEFT JOIN data_pegawai pg ON rm.id_pegawai = pg.id_pegawai
              WHERE rm.id_rekam = ?";
    
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id_rekam);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $data = $result->fetch_assoc();
        
        // Format tanggal
        $tanggal_lahir = $data['tanggal_lahir'] ? date('d M Y', strtotime($data['tanggal_lahir'])) : '-';
        $usia = $data['tanggal_lahir'] ? floor((time() - strtotime($data['tanggal_lahir'])) / 31556926) . ' tahun' : '-';
        
        echo '
        <div class="detail-row">
            <div class="detail-label">Nama Pasien</div>
            <div class="detail-value">' . htmlspecialchars($data['nama_pasien']) . '</div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Informasi Pasien</div>
            <div class="detail-value">
                ' . ($data['jenis_kelamin'] ? htmlspecialchars($data['jenis_kelamin']) : '-') . ' | 
                Lahir: ' . $tanggal_lahir . ' (' . $usia . ')
            </div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Layanan</div>
            <div class="detail-value">' . htmlspecialchars($data['nama_layanan']) . '</div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Tanggal Pemeriksaan</div>
            <div class="detail-value">' . date('d M Y', strtotime($data['tanggal_periksa'])) . '</div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Dokter/Pemeriksa</div>
            <div class="detail-value">
                ' . htmlspecialchars($data['nama_pegawai']) . '
                ' . ($data['spesialisasi'] ? '<br><small>' . htmlspecialchars($data['spesialisasi']) . '</small>' : '') . '
            </div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Keluhan</div>
            <div class="detail-value">' . nl2br(htmlspecialchars($data['keluhan'])) . '</div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Tindakan yang Dilakukan</div>
            <div class="detail-value">' . nl2br(htmlspecialchars($data['tindakan'])) . '</div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">Hasil Pemeriksaan</div>
            <div class="detail-value">' . nl2br(htmlspecialchars($data['hasil'])) . '</div>
        </div>
        
        <div class="detail-row">
            <div class="detail-label">ID Rekam Medis</div>
            <div class="detail-value">RM-' . str_pad($data['id_rekam'], 6, '0', STR_PAD_LEFT) . '</div>
        </div>';
    } else {
        echo '<div style="text-align: center; padding: 20px; color: #e74c3c;">Data tidak ditemukan.</div>';
    }
    
    $stmt->close();
}
?>