<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>

<!-- admin/data_pegawai.php -->
<div class="page-pegawai">
    <h2>👩‍⚕️ Data Pegawai</h2>
    <p>Kelola data pegawai klinik (dokter / suster / staf).</p>

    <div class="pegawai-container">
        <div class="pegawai-form">
            <h3>Tambah / Edit Pegawai</h3>
            <form id="formPegawai" onsubmit="return false;">
                <input type="hidden" id="id_pegawai" name="id_pegawai" value="">

                <label>Nama</label>
                <input type="text" id="nama" name="nama" required>

                <label>Email</label>
                <input type="email" id="email" name="email">

                <label>No HP</label>
                <input type="text" id="no_hp" name="no_hp">

                <label>Alamat</label>
                <input type="text" id="alamat" name="alamat">

                <label>Pendidikan</label>
                <input type="text" id="pendidikan" name="pendidikan">

                <label>Jenis Kelamin</label>
                <select id="jenis_kelamin" name="jenis_kelamin">
                    <option value="">-- Pilih --</option>
                    <option value="Laki-laki">Laki-laki</option>
                    <option value="Perempuan">Perempuan</option>
                </select>

                <label>Posisi</label>
                <input type="text" id="posisi" name="posisi">

                <button type="submit" class="btn-save">Simpan</button>
            </form>
        </div>

        <div class="pegawai-list">
            <h3>Daftar Pegawai</h3>
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>HP</th>
                        <th>Posisi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="tablePegawai"></tbody>
            </table>
        </div>
    </div>
</div>

<script src="../assets/js/pegawai_crud.js"></script>

