<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>
<?php
require_once("../includes/db_connect.php"); 

$query = "SELECT * FROM data_diri_pasien ORDER BY id_pasien DESC";
$result = $conn->query($query);

$qortu = "SELECT id_orangtua, nama_ortu FROM orang_tua ORDER BY nama_ortu ASC";
$res = $conn->query($qortu);
?>

<div class="page-pasien">
    <h2>🧒 Data Pasien</h2>
    <p>Kelola data pasien dan orang tua dengan penuh kasih 💙</p>

    <div class="pasien-container">
        <!-- Form Data Pasien -->
        <div class="pasien-form">
            <h3><i class="bx bx-user-plus"></i> Tambah Data Pasien</h3>
            <form action="admin/proses_pasien/tambah.php" method="POST">
                <label>Nama Orang Tua:</label>
                <select name="id_orangtua" id="id_orangtua" required>
                    <option value="">Pilih Orang Tua...</option>
                    <?php
                    while ($row = $res->fetch_assoc()) {
                        echo "<option value='{$row['id_orangtua']}'>{$row['nama_ortu']}</option>";
                    }
                    ?>
                </select>
                <label>Nama Pasien:</label>
                <input type="text" name="nama_pasien" placeholder="Contoh: Ananda Dinda" required>

                <label>Tanggal Lahir:</label>
                <input type="date" name="tgl_lahir" required>

                <label>Jenis Kelamin:</label>
                <select name="jenis_kelamin" required>
                    <option value="">Pilih jenis kelamin...</option>
                    <option value="L">Laki-laki</option>
                    <option value="P">Perempuan</option>
                </select>

                <label>Email Orang Tua:</label>
                <input type="email" name="email" placeholder="email@contoh.com" required>

                <label>No. Telepon:</label>
                <input type="text" name="no_telp" placeholder="08xxxxxxxxxx" required>

                <label>Alamat:</label>
                <textarea name="alamat" placeholder="Masukkan alamat lengkap..." required></textarea>

                <button type="submit" class="btn-save"><i class="bx bx-save"></i> Simpan Data</button>
            </form>

        </div>

        <!-- Daftar Pasien -->
        <div class="pasien-list">
            <h3><i class="bx bx-list-ul"></i> Daftar Pasien</h3>
            <table>
                <thead>
                    <tr>
                        <th>Nama Pasien</th>
                        <th>Jenis Kelamin</th>
                        <th>Orang Tua</th>
                        <th>Email</th>
                        <th>Telepon</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody id="dataPasien">
                    <?php
                    // Fetch the next row of a result set as an associative array
                    while ($res = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>".$res['nama_pasien']."</td>";
                        echo "<td>".$res['jenis_kelamin']."</td>";
                        echo "<td>".$res['id_orangtua']."</td>";
                        echo "<td>".$res['email']."</td>";
                        echo "<td>".$res['no_telp']."</td>";
                        echo "<td><button onclick='editPasien({$res['id_pasien']})'>✏️ Edit</button> |
                        <a href=\"admin/proses_pasien/delete.php?id=$res[id_pasien]\" onClick=\"return confirm('Are you sure you want to delete?')\">Delete</a></td>";
                    }
                    ?>
                </tbody>
            </table>

            <!-- Modal Edit Pasien -->
            <div id="modalEdit" class="modal">
                <div class="modal-content">
                    <span class="close">&times;</span>
                    <h3><i class="bx bx-edit"></i> Edit Data Pasien</h3>
                    <form id="formEditPasien">
                        <input type="hidden" name="id_pasien" id="edit_id_pasien">

                        <label>Nama Pasien:</label>
                        <input type="text" name="nama_pasien" id="edit_nama_pasien" required>

                        <label>Tanggal Lahir:</label>
                        <input type="date" name="tgl_lahir" id="edit_tgl_lahir" required>

                        <label>Jenis Kelamin:</label>
                        <select name="jenis_kelamin" id="edit_jenis_kelamin" required>
                            <option value="L">Laki-laki</option>
                            <option value="P">Perempuan</option>
                        </select>

                        <label>Email Orang Tua:</label>
                        <input type="email" name="email" id="edit_email" required>

                        <label>No. Telepon:</label>
                        <input type="text" name="no_telp" id="edit_no_telp" required>

                        <label>Alamat:</label>
                        <textarea name="alamat" id="edit_alamat" required></textarea>

                        <button type="submit" class="btn-save"><i class="bx bx-save"></i> Update Data</button>
                    </form>
                </div>
            </div>

            <style>
                /* ===== Modal Style ===== */
                .modal {
                    display: none;
                    /* awalnya disembunyikan */
                    position: fixed;
                    z-index: 1000;
                    left: 0;
                    top: 0;
                    width: 100%;
                    height: 100%;
                    background-color: rgba(0, 0, 0, 0.5);
                    justify-content: center;
                    align-items: center;
                }

                /* Konten modal */
                .modal-content {
                    background-color: #fff;
                    padding: 25px 30px;
                    border-radius: 12px;
                    width: 420px;
                    max-width: 90%;
                    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
                    animation: fadeIn 0.3s ease;
                    position: relative;
                }

                .modal-content h3 {
                    margin-top: 0;
                    text-align: center;
                    font-weight: 700;
                    color: #2a7ae4;
                }

                .modal-content label {
                    display: block;
                    margin-top: 12px;
                    font-weight: 600;
                    color: #333;
                }

                .modal-content input,
                .modal-content select,
                .modal-content textarea {
                    width: 100%;
                    padding: 8px 10px;
                    margin-top: 5px;
                    border-radius: 6px;
                    border: 1px solid #ccc;
                    outline: none;
                    transition: border-color 0.2s;
                }

                .modal-content input:focus,
                .modal-content select:focus,
                .modal-content textarea:focus {
                    border-color: #2a7ae4;
                }

                /* Tombol simpan */
                .btn-save {
                    margin-top: 18px;
                    background-color: #2a7ae4;
                    color: #fff;
                    border: none;
                    border-radius: 6px;
                    padding: 10px 16px;
                    width: 100%;
                    font-weight: 600;
                    cursor: pointer;
                    transition: background-color 0.2s;
                }

                .btn-save:hover {
                    background-color: #1e63c6;
                }

                /* Tombol close (X) */
                .close {
                    position: absolute;
                    top: 12px;
                    right: 16px;
                    font-size: 24px;
                    color: #777;
                    cursor: pointer;
                    transition: color 0.2s;
                }

                .close:hover {
                    color: #111;
                }

                /* Animasi lembut */
                @keyframes fadeIn{
                from{
                    opacity: 0;
                    transform: translateY(-20px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }}
                

            </style>


        </div>
    </div>
</div>
<script>
        const modal = document.getElementById("modalEdit");
        const closeBtn = modal.querySelector(".close");
        const formEdit = document.getElementById("formEditPasien");
        
    window.editPasien = function (id) {
        console.log("Klik edit pasien id:", id);

        // tampilkan modal
        document.getElementById('modalEdit').style.display = 'block';

        // ambil data pasien
        fetch(`admin/proses_pasien/edit.php?id=${id}`)
            .then(res => res.json())
            .then(data => {
                document.getElementById('edit_id_pasien').value = data.id_pasien;
                document.getElementById('edit_nama_pasien').value = data.nama_pasien;
                document.getElementById('edit_tgl_lahir').value = data.tgl_lahir;
                document.getElementById('edit_jenis_kelamin').value = data.jenis_kelamin;
                document.getElementById('edit_email').value = data.email;
                document.getElementById('edit_no_telp').value = data.no_telp;
                document.getElementById('edit_alamat').value = data.alamat;
            })
            .catch(err => console.error('Gagal ambil data pasien:', err));
    }
    formEdit.addEventListener("submit", e => {
        e.preventDefault();

        const fd = new FormData(formEdit);
        fd.append("update", "1"); // <--- wajib biar PHP detect $_POST['update']

        fetch("admin/proses_pasien/edit.php", {
            method: "POST",
            body: fd
        })
        .then(res => res.text())
        .then(res => {
            if (res.trim() === "success") {
                alert("✅ Data pasien berhasil diperbarui!");
                document.getElementById("modalEdit").style.display = "none";
                location.reload();
            } else {
                alert("❌ Gagal memperbarui data pasien.");
                console.log("Response dari server:", res);
            }
        })
        .catch(err => {
            console.error("Gagal update data:", err);
            alert("Terjadi kesalahan koneksi ke server.");
        });
    });

</script>

<script>
    // Tutup modal saat klik tombol X
    document.addEventListener("click", function (e) {
        const modal = document.getElementById("modalEdit");
        if (e.target.classList.contains("close")) {
            modal.style.display = "none";
        }
    });

    // Tutup modal saat klik di luar modal
    window.onclick = function (event) {
        const modal = document.getElementById("modalEdit");
        if (event.target === modal) {
            modal.style.display = "none";
        }
    };
</script>



