<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}
?>
<?php
require_once("../includes/db_connect.php"); 

$query = "SELECT * FROM orang_tua ORDER BY id_orangtua DESC";
$result = $conn->query($query);
?>

<section class="orangtua-container">
    <h2>👨‍👩‍👧 Data Orang Tua Pasien</h2>
    <button class="btn-tambah" id="btnTambah">+ Tambah Orang Tua</button>

    <table class="tabel-orangtua">
        <thead>
            <tr>
                <th>Nama Orang Tua</th>
                <th>Kontak</th>
                <th>Alamat</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody id="dataOrangtua">
            <?php
                    // Fetch the next row of a result set as an associative array
                    while ($res = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>".$res['nama_ortu']."</td>";
                        echo "<td>".$res['kontak_ortu']."</td>";
                        echo "<td>".$res['alamat']."</td>";
                        echo "<td><button onclick='editPasien({$res['id_orangtua']})'>✏️ Edit</button> |
                        <a href=\"admin/proses_orangtua/delete.php?id=$res[id_orangtua]\" onClick=\"return confirm('Are you sure you want to delete?')\">Delete</a></td>";
                    }
                    ?>
        </tbody>
    </table>
</section>

<!-- Modal Form -->
<div class="modal" id="modalOrtu">
    <div class="modal-content">
        <span class="close" id="closeModal">&times;</span>
        <h3 id="modalTitle">Tambah Data Orang Tua</h3>

        <form id="formOrtu">
            <input type="hidden" name="id_orangtua" id="id_orangtua">

            <label>Nama Orang Tua:</label>
            <input type="text" name="nama_ortu" id="nama_ortu" required>

            <label>Kontak:</label>
            <input type="text" name="kontak_ortu" id="kontak_ortu">

            <label>Alamat:</label>
            <textarea name="alamat" id="alamat" rows="3"></textarea>

            <button type="submit" class="btn-simpan">Simpan</button>
        </form>
    </div>
</div>

<!-- JavaScript CRUD -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const modal = document.getElementById("modalOrtu");
        const btnTambah = document.getElementById("btnTambah");
        const closeModal = document.getElementById("closeModal");
        const form = document.getElementById("formOrtu");
        const tbody = document.getElementById("dataOrangtua");

        function loadData() {
            fetch("proses/orangtua_read.php")
                .then(res => res.text())
                .then(data => tbody.innerHTML = data);
        }

        loadData();

        btnTambah.onclick = () => {
            modal.style.display = "flex";
            form.reset();
            document.getElementById("modalTitle").textContent = "Tambah Data Orang Tua";
        };

        closeModal.onclick = () => modal.style.display = "none";

        form.onsubmit = e => {
            e.preventDefault();
            const formData = new FormData(form);
            fetch("proses/orangtua_save.php", {
                    method: "POST",
                    body: formData
                })
                .then(res => res.text())
                .then(() => {
                    modal.style.display = "none";
                    loadData();
                });
        };

        tbody.addEventListener("click", e => {
            if (e.target.classList.contains("edit")) {
                const id = e.target.dataset.id;
                fetch("proses/orangtua_get.php?id=" + id)
                    .then(res => res.json())
                    .then(data => {
                        document.getElementById("id_orangtua").value = data.id_orangtua;
                        document.getElementById("nama_ortu").value = data.nama_ortu;
                        document.getElementById("kontak_ortu").value = data.kontak_ortu;
                        document.getElementById("alamat").value = data.alamat;
                        modal.style.display = "flex";
                        document.getElementById("modalTitle").textContent = "Edit Data Orang Tua";
                    });
            } else if (e.target.classList.contains("hapus")) {
                const id = e.target.dataset.id;
                if (confirm("Yakin ingin menghapus data ini?")) {
                    fetch("proses/orangtua_delete.php?id=" + id)
                        .then(res => res.text())
                        .then(() => loadData());
                }
            }
        });
    });
</script>

<!-- 🎨 CSS -->
<style>
    .orangtua-container {
        background: #f0f9ff;
        border-radius: 12px;
        padding: 20px;
        animation: fadeIn 0.5s ease;
    }

    h2 {
        color: #2266aa;
        margin-bottom: 15px;
    }

    .btn-tambah {
        background: linear-gradient(135deg, #8fd3f4, #84fab0);
        color: #fff;
        border: none;
        padding: 10px 18px;
        border-radius: 8px;
        cursor: pointer;
        transition: 0.3s;
    }

    .btn-tambah:hover {
        transform: scale(1.05);
    }

    .tabel-orangtua {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
        background: #fff;
        border-radius: 10px;
        overflow: hidden;
    }

    .tabel-orangtua th {
        background: #b9f3fc;
        color: #333;
        padding: 10px;
    }

    .tabel-orangtua td {
        padding: 10px;
        text-align: center;
        border-bottom: 1px solid #ddd;
    }

    .modal {
        position: fixed;
        display: none;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.4);
        justify-content: center;
        align-items: center;
    }

    .modal-content {
        background: #fff;
        border-radius: 12px;
        padding: 20px;
        width: 400px;
        animation: slideDown 0.4s ease;
    }

    .close {
        float: right;
        cursor: pointer;
        font-size: 20px;
    }

    .btn-simpan {
        background: #00c6ff;
        color: white;
        padding: 8px 14px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        transition: 0.3s;
    }

    .btn-simpan:hover {
        background: #0099cc;
    }

    @keyframes slideDown{ from {
        transform: translateY(-20px);
        opacity: 0;
    }

    to {
        transform: translateY(0);
        opacity: 1;
    }
    }

    @keyframes fadeIn {from {
        opacity: 0;
        transform: translateY(10px);
    }

    to {
        opacity: 1;
        transform: translateY(0);
    }
    }
</style>
