<?php
session_start();

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['id_admin'])) {
    header("Location: ../login_admin.php");
    exit();
}

// Ambil data admin dari session
$nama_admin = $_SESSION['nama_admin'];
$username = $_SESSION['username'];
$email_admin = $_SESSION['email_admin'];
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Klinik Gigi Anak Ceria</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>
    <div class="dashboard">
        <h2>Selamat Datang, <?= htmlspecialchars($nama_admin) ?> 🦷</h2>
        <p>Yuk cek aktivitas klinik hari ini!</p>

        <!-- Cards Statistik -->
        <div class="stats-container">
            <div class="stat-card" style="--color:#A2D2FF;">
                <i class="bx bx-calendar-check"></i>
                <div>
                    <h3>12</h3>
                    <p>Janji Temu Hari Ini</p>
                </div>
            </div>

            <div class="stat-card" style="--color:#FFC8DD;">
                <i class="bx bx-user"></i>
                <div>
                    <h3>35</h3>
                    <p>Pasien Terdaftar</p>
                </div>
            </div>

            <div class="stat-card" style="--color:#FFAFCC;">
                <i class="bx bx-package"></i>
                <div>
                    <h3>5</h3>
                    <p>Stok Menipis</p>
                </div>
            </div>

            <div class="stat-card" style="--color:#BDE0FE;">
                <i class="bx bx-wallet"></i>
                <div>
                    <h3>Rp 3.200.000</h3>
                    <p>Pemasukan Bulan Ini</p>
                </div>
            </div>
        </div>

        <!-- Grafik Placeholder -->
        <div class="chart-section">
            <h3>Statistik Kunjungan Mingguan</h3>
            <div class="chart-placeholder">
                <canvas id="chart"></canvas>
            </div>
        </div>

        <!-- Daftar Janji Temu -->
        <div class="appointments">
            <h3>Janji Temu Terbaru</h3>
            <table class="table-cute">
                <thead>
                    <tr>
                        <th>Nama Pasien</th>
                        <th>Tanggal</th>
                        <th>Waktu</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Lisa Putri</td>
                        <td>11 Okt 2025</td>
                        <td>09:30</td>
                        <td><span class="badge success">Terverifikasi</span></td>
                    </tr>
                    <tr>
                        <td>Budi Kecil</td>
                        <td>11 Okt 2025</td>
                        <td>10:00</td>
                        <td><span class="badge pending">Menunggu</span></td>
                    </tr>
                    <tr>
                        <td>Siti Mawar</td>
                        <td>11 Okt 2025</td>
                        <td>10:30</td>
                        <td><span class="badge done">Selesai</span></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Tombol Logout -->
        <div style="margin-top: 30px; text-align: center;">
            <a href="../includes/logout_admin.php" class="btn-logout">
                <i class="bx bx-log-out"></i> Logout
            </a>
        </div>
    </div>

    <!-- Grafik -->
    <script>
        const ctx = document.getElementById('chart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab', 'Min'],
                datasets: [{
                    label: 'Kunjungan',
                    data: [8, 12, 9, 14, 10, 7, 11],
                    borderColor: '#FFAFCC',
                    backgroundColor: '#FFC8DD80',
                    fill: true,
                    tension: 0.4,
                }]
            },
            options: {
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
</body>

</html>
